#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/app_options_menu'
require_relative '../../pages/landing_appointments'
require_relative '../../module/database/OracleUtility'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../module/DateUtility'
require_relative '../../pages/user_menu'
require_relative '../../module/database/OracleUtility'
require_relative '../../common/cancel_appointment'


describe '[Story# VAR-12367: Update the upcoming appointments screen loading functionality]'  do
  include DriverUtility
  include OracleUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @eula = Eula.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    APPOINTMENTS = "Appointments/Requests"
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @@timeSlot = "11:00"
    #cancel existing appointment
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysFromNow} 11:00:00")
    @cancel_appointment.cancel_appointment()

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-12367|TC#VAR-12576: Validate Update the upcoming appointments screen loading]'do

    it "Verify Loading message" do
      @common.loginEndsOnHome(pw_redacted)
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      @landing_appointments.clickRefresh
      @modal.loadingModal_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.loadingModal).to eq("Loading your appointment data. This step may take a few minutes.")
    end

    it 'Should verify loading text after selecting clinic' do
      sleep 2
      @common.waitWhileSpinnerPresent
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.clinic_radio_elements[1].when_present(TIME_OUT_LIMIT)
      @new_appointment.select_clinic_radio("32")
      @modal.loadingModal_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.loadingModal).to eq("Loading your appointment data. This step may take a few minutes.")
    end

    it "should verify loading text after schedule appointment is clicked" do
      @new_appointment.provideReasonForAppointment("This is new switched clinic")
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@timeSlot)
      @@setDate = NewAppointmentRequest.bookedDate
      @new_appointment.enterEmail("testSC@test.com")
      @new_appointment.schedule_appointment_element.wait_until_present(TIME_OUT_LIMIT)
      button_element = @driver.button(:id => 'schedule-appointment-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @modal.loadingModal_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.loadingModal).to eq("Loading your appointment data. This step may take a few minutes.")
    end

    it "Verify appointment is scheduled" do
      @common.waitWhileSpinnerPresent()
      Watir::Wait.until {@detail.appointment_details_group_element.present?}
      Watir::Wait.until {@detail.appointment_details_group_element.text.include?("Reason for Appointment")}
      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")
    end

    it "should verify loading text when appointment is being cancelled" do
      @detail.cancel_appointment_element.when_present(TIME_OUT_LIMIT)
      @detail.cancel_appointment
      @modal.loadingModal_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.loadingModal).to eq("Processing your cancellation. This step may take a few minutes.")
    end

    it "should verify loading text when appointment cancellation is confirmed" do
      @common.waitWhileSpinnerPresent
      @detail.selectReasonForCancellation("TRANSFER OPT CARE TO OTHER VA")
      sleep 2
      @detail.confirm_cancellation_element.when_present(TIME_OUT_LIMIT)
      button_element = @driver.button(:id => 'cancel-appointment-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @modal.loadingModal_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.loadingModal).to eq("Processing your cancellation. This step may take a few minutes.")
    end
  end
end








